typedef struct ACTOR ACTOR;
struct ACTOR {
	int type;
	float x, y;
	float dx, dy;
	float l, r, t, b;
	int frame;
	int anim;
	int hit;
	int health;
	int timer;
	void (*draw)(ACTOR *actor, int x, int y);
};

enum {MAN = 0, TREE, F18, TOWER, FIR};

void actor_init(ACTOR *actor);
void actor_draw(ACTOR *actor, int x, int y);
int actor_collide(ACTOR *actor, ACTOR *with);
int actor_inside(ACTOR *actor, ACTOR *with);

void actors_draw(int x, int y);
void actors_process(void);
